<?php
/**
 * @package WordPress
 * @subpackage Resideo
 */

if (!function_exists('resideo_admin_setup')): 
    function resideo_admin_setup() {
        add_settings_section('resideo_setup_section', __('Theme Setup', 'resideo-plugin'), 'resideo_setup_section_callback', 'resideo_setup_settings');
    }
endif;

if (!function_exists('resideo_setup_section_callback')): 
    function resideo_setup_section_callback() { 
        wp_nonce_field('theme_setup_ajax_nonce', 'securityThemeSetup', true);

        print '<p class="help">' . __('If you choose to import the demo content, you can run this setup to make your website look like the theme demo.', 'resideo-plugin') . '</p>
                <table class="form-table">
                    <tbody>
                        <tr>
                            <th scope="row">' . __('Demo 1', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-1"> ' . __('I have imported Demo 1 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-1" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-1"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 2', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-2"> ' . __('I have imported Demo 2 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-2" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-2"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 3', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-3"> ' . __('I have imported Demo 3 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-3" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-3"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 4', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-4"> ' . __('I have imported Demo 4 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-4" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-4"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 5', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-5"> ' . __('I have imported Demo 5 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-5" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-5"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 6', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-6"> ' . __('I have imported Demo 6 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-6" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-6"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 7', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-7"> ' . __('I have imported Demo 7 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-7" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-7"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 8', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-8"> ' . __('I have imported Demo 8 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-8" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-8"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 9', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-9"> ' . __('I have imported Demo 9 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-9" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-9"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 10', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-10"> ' . __('I have imported Demo 10 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-10" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-10"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 11', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-11"> ' . __('I have imported Demo 11 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-11" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-11"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">' . __('Demo 12', 'resideo-plugin') . '</th>
                            <td>
                                <label><input type="radio" name="demo_version" value="demo-12"> ' . __('I have imported Demo 12 content', 'resideo-plugin') . '</label><p class="submit theme-setup-btn"><input type="button" id="theme-setup-btn-12" class="button button-primary" value="' . __('Run Setup', 'resideo-plugin') . '" data-demo="demo-12"></p>
                                <ul class="theme-setup-msg">
                                    <li class="theme-setup-permalinks-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up permalinks...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-homepage-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up homepage...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-menu-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up menu...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-widgets-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up widgets...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                    <li class="theme-setup-options-msg">
                                        <span class="fa fa-spin fa-spinner"></span><span class="fa fa-check"></span> ' . __('Setting up options...', 'resideo-plugin') . '<span class="msg-done">' . __('Done', 'resideo-plugin') . '</span>
                                    </li>
                                </ul>
                                <p class="theme-setup-done">' . __('All done.', 'resideo-plugin') . ' <a href="' . admin_url() . '">' . __('Have fun!', 'resideo-plugin') . '</a></p>
                            </td>
                        </tr>
                    </tbody>
                </table>';
    }
endif;

if (!function_exists('resideo_setup_permalinks')): 
    function resideo_setup_permalinks() {
        check_ajax_referer('theme_setup_ajax_nonce', 'security');

        global $wp_rewrite;

        $wp_rewrite->set_permalink_structure('/%postname%/');
        $wp_rewrite->flush_rules();

        echo json_encode(array('setup' => true));
        exit();

        die;
    }
endif;
add_action('wp_ajax_nopriv_resideo_setup_permalinks', 'resideo_setup_permalinks');
add_action('wp_ajax_resideo_setup_permalinks', 'resideo_setup_permalinks');

if (!function_exists('resideo_setup_reading_pages')): 
    function resideo_setup_reading_pages() {
        check_ajax_referer('theme_setup_ajax_nonce', 'security');

        update_option('show_on_front', 'page');

        $home_page = get_page_by_title('Home');
        $blog_page = get_page_by_title('Blog');

        if (isset($home_page->ID)) {
            update_option('page_on_front', $home_page->ID);
        }

        if (isset($blog_page->ID)) {
            update_option('page_for_posts', $blog_page->ID);
        }

        echo json_encode(array('setup' => true));
        exit();

        die;
    }
endif;
add_action('wp_ajax_nopriv_resideo_setup_reading_pages', 'resideo_setup_reading_pages');
add_action('wp_ajax_resideo_setup_reading_pages', 'resideo_setup_reading_pages');

if (!function_exists('resideo_setup_menu')): 
    function resideo_setup_menu() {
        check_ajax_referer('theme_setup_ajax_nonce', 'security');

        $demo_menus = array(
            'primary' => __('Top Menu', 'resideo-plugin')
        );

        $locations  = get_theme_mod('nav_menu_locations');
        $ep_menus   = wp_get_nav_menus();

        $menu_conf  = $demo_menus;

        if (!empty($ep_menus) && !empty($menu_conf)) {
            foreach ($ep_menus as $ep_menu) {
                if (is_object($ep_menu) && in_array($ep_menu->name, $menu_conf)) {
                    $key = array_search($ep_menu->name, $menu_conf);

                    if ($key !== false) {
                        $locations[$key] = $ep_menu->term_id;
                    }
                }
            }
        }

        set_theme_mod('nav_menu_locations', $locations);

        echo json_encode(array('setup' => true));
        exit();

        die;
    }
endif;
add_action('wp_ajax_nopriv_resideo_setup_menu', 'resideo_setup_menu');
add_action('wp_ajax_resideo_setup_menu', 'resideo_setup_menu');

if (!function_exists('resideo_setup_widgets')): 
    function resideo_setup_widgets() {
        check_ajax_referer('theme_setup_ajax_nonce', 'security');

        $demo_version = isset($_POST['demo']) ? sanitize_text_field($_POST['demo']) : '';

        // Export widgets using this plugin http://wordpress.org/plugins/widget-settings-importexport/

        switch ($demo_version) {
            case 'demo-1':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-2","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"2":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-2':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-3':
                $demo_widgets = '[{"pxp-main-widget-area":["search-3","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"3":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-4':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-5':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-6':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-7':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-2","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"2":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-8':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-9':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-2","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"2":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-10':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-11':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-2","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"2":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            case 'demo-12':
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-3","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"3":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
            default:
                $demo_widgets = '[{"pxp-main-widget-area":["search-2","resideo_recent_posts_widget-2","categories-2","tag_cloud-2"],"pxp-first-footer-widget-area":["resideo_contact_widget-2","resideo_social_widget-2"],"pxp-second-footer-widget-area":["nav_menu-2"],"pxp-third-footer-widget-area":["nav_menu-3"],"pxp-fourth-footer-widget-area":["nav_menu-4"]},{"search":{"2":{"title":"Search Articles"},"_multiwidget":1},"resideo_recent_posts_widget":{"2":{"title":"Recent Articles","date":false,"limit":"5"},"_multiwidget":1},"categories":{"2":{"title":"Categories","count":1,"hierarchical":0,"dropdown":0},"_multiwidget":1},"tag_cloud":{"2":{"title":"Tags","count":0,"taxonomy":"post_tag"},"_multiwidget":1},"resideo_contact_widget":{"2":{"title":"","logo":1,"line_1":"90 Fifth Avenue, 3rd Floor","line_2":"San Francisco, CA 1980","line_3":"(123) 456-7890"},"_multiwidget":1},"resideo_social_widget":{"2":{"title":"","instagram":"#","facebook":"#","twitter":"#","linkedin":"","pinterest":""},"_multiwidget":1},"nav_menu":{"2":{"title":"Company","nav_menu":13},"3":{"title":"Services","nav_menu":14},"4":{"title":"Explore","nav_menu":15},"_multiwidget":1}}]';
                break;
        }

        $sidebars_widgets = wp_get_sidebars_widgets();

        foreach ($sidebars_widgets as $sidebar_id => $widgets) {
            if ($sidebar_id != 'wp_inactive_widgets') {
                $sidebars_widgets[$sidebar_id] = array();
            }
        }

        wp_set_sidebars_widgets($sidebars_widgets);

        $json_data    = json_decode($demo_widgets, true);
        $sidebar_data = $json_data[0];
        $widget_data  = $json_data[1];

        foreach ($sidebar_data as $title => $sidebar) {
            $count = count($sidebar);

            for ($i = 0; $i < $count; $i++) {
                $widget               = array();
                $widget['type']       = trim(substr($sidebar[$i], 0, strrpos($sidebar[$i], '-')));
                $widget['type-index'] = trim(substr($sidebar[$i], strrpos($sidebar[$i], '-') + 1));

                if (!isset($widget_data[$widget['type']][$widget['type-index']])) {
                    unset($sidebar_data[$title][$i]);
                }
            }

            $sidebar_data[$title] = array_values($sidebar_data[$title]);
        }

        $sidebar_data = array(array_filter($sidebar_data), $widget_data);

        resideo_import_widgets_parse_data($sidebar_data);

        echo json_encode(array('setup' => true));
        exit();

        die;
    }
endif;
add_action('wp_ajax_nopriv_resideo_setup_widgets', 'resideo_setup_widgets');
add_action('wp_ajax_resideo_setup_widgets', 'resideo_setup_widgets');

if (!function_exists('resideo_import_widgets_parse_data')): 
    function resideo_import_widgets_parse_data($import_array) {
        $sidebars_data = $import_array[0];
        $widget_data   = $import_array[1];

        $current_sidebars = get_option('sidebars_widgets');
        $new_widgets      = array();

        foreach ($sidebars_data as $import_sidebar => $import_widgets) :
            $current_sidebars[$import_sidebar] = array();

            foreach ($import_widgets as $import_widget) :
                $title               = trim(substr($import_widget, 0, strrpos($import_widget, '-')));
                $index               = trim(substr($import_widget, strrpos($import_widget, '-') + 1));
                $current_widget_data = get_option('widget_' . $title);
                $new_widget_name     = resideo_get_new_widget_name($title, $index);
                $new_index           = trim(substr($new_widget_name, strrpos($new_widget_name, '-') + 1));

                if (!empty($new_widgets[$title]) && is_array($new_widgets[$title])) {
                    while (array_key_exists($new_index, $new_widgets[$title])) {
                        $new_index++;
                    }
                }

                $current_sidebars[$import_sidebar][] = $title . '-' . $new_index;

                if (array_key_exists($title, $new_widgets)) {
                    $new_widgets[$title][$new_index] = $widget_data[$title][$index];

                    if (!empty($new_widgets[$title]['_multiwidget'])) {
                        $multiwidget = $new_widgets[$title]['_multiwidget'];
                        unset($new_widgets[$title]['_multiwidget']);
                        $new_widgets[$title]['_multiwidget'] = $multiwidget;
                    } else {
                        $new_widgets[$title]['_multiwidget'] = null;
                    }
                } else {
                    $current_widget_data[$new_index] = $widget_data[$title][$index];

                    if (!empty($current_widget_data['_multiwidget'])) {
                        $current_multiwidget = $current_widget_data['_multiwidget'];
                        $new_multiwidget     = $widget_data[$title]['_multiwidget'];
                        $multiwidget         = ($current_multiwidget != $new_multiwidget) ? $current_multiwidget : 1;
                        unset($current_widget_data['_multiwidget']);
                        $current_widget_data['_multiwidget'] = $multiwidget;
                    } else {
                        $current_widget_data['_multiwidget'] = null;
                    }

                    $new_widgets[$title] = $current_widget_data;
                }
            endforeach;
        endforeach;

        if (isset($new_widgets) && isset($current_sidebars)) {
            update_option('sidebars_widgets', $current_sidebars);

            foreach ($new_widgets as $title => $content) {
                update_option('widget_' . $title, $content);
            }
        }
    }
endif;

if (!function_exists('resideo_get_new_widget_name')): 
    function resideo_get_new_widget_name($widget_name, $widget_index) {
        $current_sidebars = get_option('sidebars_widgets');
        $all_widget_array = array();

        foreach ($current_sidebars as $sidebar => $widgets) {
            if (!empty($widgets) && is_array($widgets) && $sidebar != 'wp_inactive_widgets') {
                foreach ($widgets as $widget) {
                    $all_widget_array[] = $widget;
                }
            }
        }

        while (in_array($widget_name . '-' . $widget_index, $all_widget_array)) {
            $widget_index ++;
        }

        $new_widget_name = $widget_name . '-' . $widget_index;

        return $new_widget_name;
    }
endif;

if (!function_exists('resideo_setup_options')): 
    function resideo_setup_options() {
        check_ajax_referer('theme_setup_ajax_nonce', 'security');

        $demo_version = isset($_POST['demo']) ? sanitize_text_field($_POST['demo']) : '';

        // Export theme settings using this plugin https://wordpress.org/plugins/options-importer/ and copy only the theme settings array from the json file

        switch ($demo_version) {
            case 'demo-1':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:10:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_details_field\";s:4:\"tabs\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:8:\"required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-2':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:8:\"disabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-3':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:0:\"\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:8:\"required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-4':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:4:\"dark\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"0\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"1\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"2\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"3\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-5':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:4:\"dark\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-6':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:4:\"dark\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-7':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:10:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:26:\"resideo_property_top_field\";s:7:\"gallery\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_colors_settings": "a:17:{s:29:\"resideo_header_bg_color_field\";s:0:\"\";s:31:\"resideo_header_logo_color_field\";s:0:\"\";s:30:\"resideo_header_nav_color_field\";s:0:\"\";s:36:\"resideo_header_user_icon_color_field\";s:0:\"\";s:29:\"resideo_button_bg_color_field\";s:7:\"#0061df\";s:31:\"resideo_button_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_prop_bg_color_field\";s:7:\"#0061df\";s:34:\"resideo_feat_prop_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_post_bg_color_field\";s:0:\"\";s:34:\"resideo_feat_post_text_color_field\";s:0:\"\";s:33:\"resideo_map_marker_bg_color_field\";s:7:\"#ffffff\";s:37:\"resideo_map_marker_border_color_field\";s:7:\"#0061df\";s:35:\"resideo_map_marker_text_color_field\";s:7:\"#0061df\";s:34:\"resideo_agent_card_cta_color_field\";s:7:\"#0061df\";s:33:\"resideo_post_card_cta_color_field\";s:7:\"#0061df\";s:29:\"resideo_footer_bg_color_field\";s:0:\"\";s:31:\"resideo_footer_text_color_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:8:\"required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-8':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:4:\"dark\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_colors_settings": "a:17:{s:29:\"resideo_header_bg_color_field\";s:0:\"\";s:31:\"resideo_header_logo_color_field\";s:0:\"\";s:30:\"resideo_header_nav_color_field\";s:0:\"\";s:36:\"resideo_header_user_icon_color_field\";s:0:\"\";s:29:\"resideo_button_bg_color_field\";s:7:\"#f97822\";s:31:\"resideo_button_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_prop_bg_color_field\";s:7:\"#f97822\";s:34:\"resideo_feat_prop_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_post_bg_color_field\";s:7:\"#f97822\";s:34:\"resideo_feat_post_text_color_field\";s:7:\"#ffffff\";s:33:\"resideo_map_marker_bg_color_field\";s:7:\"#000000\";s:37:\"resideo_map_marker_border_color_field\";s:7:\"#f97822\";s:35:\"resideo_map_marker_text_color_field\";s:7:\"#f97822\";s:34:\"resideo_agent_card_cta_color_field\";s:7:\"#f97822\";s:33:\"resideo_post_card_cta_color_field\";s:7:\"#f97822\";s:29:\"resideo_footer_bg_color_field\";s:0:\"\";s:31:\"resideo_footer_text_color_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"0\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"1\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"2\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"3\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
            case 'demo-9':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:11:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:31:\"resideo_header_background_field\";s:11:\"transparent\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"10\";s:39:\"resideo_properties_per_page_agent_field\";s:0:\"\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_colors_settings": "a:17:{s:29:\"resideo_header_bg_color_field\";s:0:\"\";s:31:\"resideo_header_logo_color_field\";s:0:\"\";s:30:\"resideo_header_nav_color_field\";s:0:\"\";s:36:\"resideo_header_user_icon_color_field\";s:0:\"\";s:29:\"resideo_button_bg_color_field\";s:0:\"\";s:31:\"resideo_button_text_color_field\";s:0:\"\";s:32:\"resideo_feat_prop_bg_color_field\";s:7:\"#ebd2b4\";s:34:\"resideo_feat_prop_text_color_field\";s:7:\"#000000\";s:32:\"resideo_feat_post_bg_color_field\";s:7:\"#ebd2b4\";s:34:\"resideo_feat_post_text_color_field\";s:7:\"#000000\";s:33:\"resideo_map_marker_bg_color_field\";s:0:\"\";s:37:\"resideo_map_marker_border_color_field\";s:0:\"\";s:35:\"resideo_map_marker_text_color_field\";s:0:\"\";s:34:\"resideo_agent_card_cta_color_field\";s:0:\"\";s:33:\"resideo_post_card_cta_color_field\";s:0:\"\";s:29:\"resideo_footer_bg_color_field\";s:7:\"#ebd2b4\";s:31:\"resideo_footer_text_color_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:12:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:31:\"resideo_map_marker_price_format\";s:5:\"short\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2021 Resideo.\";}","resideo_gmaps_settings": "a:6:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";s:25:\"resideo_gmaps_style_field\";s:410:\"%5B%7B%22featureType%22%3A%22all%22%2C%22elementType%22%3A%22all%22%2C%22stylers%22%3A%5B%7B%22hue%22%3A%22%23ffbb00%22%7D%5D%7D%2C%7B%22featureType%22%3A%22all%22%2C%22elementType%22%3A%22geometry.fill%22%2C%22stylers%22%3A%5B%7B%22hue%22%3A%22%23ffbb00%22%7D%5D%7D%2C%7B%22featureType%22%3A%22all%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22hue%22%3A%22%23ffbb00%22%7D%5D%7D%5D\";s:23:\"resideo_gmaps_poi_field\";s:1:\"1\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:8:\"required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}","resideo_property_layout_settings": "a:3:{s:29:\"resideo_property_layout_field\";s:2:\"d3\";s:33:\"resideo_property_layout_top_field\";s:7:\"gallery\";s:42:\"resideo_property_layout_map_position_field\";s:4:\"left\";}"}';
                break;
            case 'demo-10':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:4:\"dark\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_colors_settings": "a:17:{s:29:\"resideo_header_bg_color_field\";s:0:\"\";s:31:\"resideo_header_logo_color_field\";s:0:\"\";s:30:\"resideo_header_nav_color_field\";s:0:\"\";s:36:\"resideo_header_user_icon_color_field\";s:0:\"\";s:29:\"resideo_button_bg_color_field\";s:7:\"#0061df\";s:31:\"resideo_button_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_prop_bg_color_field\";s:7:\"#0061df\";s:34:\"resideo_feat_prop_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_post_bg_color_field\";s:7:\"#0061df\";s:34:\"resideo_feat_post_text_color_field\";s:7:\"#ffffff\";s:33:\"resideo_map_marker_bg_color_field\";s:7:\"#000000\";s:37:\"resideo_map_marker_border_color_field\";s:7:\"#0061df\";s:35:\"resideo_map_marker_text_color_field\";s:7:\"#0061df\";s:34:\"resideo_agent_card_cta_color_field\";s:7:\"#0061df\";s:33:\"resideo_post_card_cta_color_field\";s:7:\"#0061df\";s:29:\"resideo_footer_bg_color_field\";s:0:\"\";s:31:\"resideo_footer_text_color_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"0\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"1\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"2\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"3\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:5:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";s:25:\"resideo_gmaps_style_field\";s:2517:\"%5B%7B%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23242f3e%22%7D%5D%7D%2C%7B%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23746855%22%7D%5D%7D%2C%7B%22elementType%22%3A%22labels.text.stroke%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23242f3e%22%7D%5D%7D%2C%7B%22featureType%22%3A%22administrative.locality%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23d59563%22%7D%5D%7D%2C%7B%22featureType%22%3A%22poi%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23d59563%22%7D%5D%7D%2C%7B%22featureType%22%3A%22poi.park%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23263c3f%22%7D%5D%7D%2C%7B%22featureType%22%3A%22poi.park%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%236b9a76%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%2338414e%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road%22%2C%22elementType%22%3A%22geometry.stroke%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23212a37%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%239ca5b3%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road.highway%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23746855%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road.highway%22%2C%22elementType%22%3A%22geometry.stroke%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%231f2835%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road.highway%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23f3d19c%22%7D%5D%7D%2C%7B%22featureType%22%3A%22transit%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%232f3948%22%7D%5D%7D%2C%7B%22featureType%22%3A%22transit.station%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23d59563%22%7D%5D%7D%2C%7B%22featureType%22%3A%22water%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%2317263c%22%7D%5D%7D%2C%7B%22featureType%22%3A%22water%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23515c6d%22%7D%5D%7D%2C%7B%22featureType%22%3A%22water%22%2C%22elementType%22%3A%22labels.text.stroke%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%2317263c%22%7D%5D%7D%5D\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}","resideo_property_layout_settings": "a:3:{s:29:\"resideo_property_layout_field\";s:2:\"d5\";s:33:\"resideo_property_layout_top_field\";s:5:\"title\";s:42:\"resideo_property_layout_map_position_field\";s:4:\"left\";}"}';
                break;
            case 'demo-11':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:10:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:26:\"resideo_property_top_field\";s:7:\"gallery\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_colors_settings": "a:17:{s:29:\"resideo_header_bg_color_field\";s:0:\"\";s:31:\"resideo_header_logo_color_field\";s:0:\"\";s:30:\"resideo_header_nav_color_field\";s:0:\"\";s:36:\"resideo_header_user_icon_color_field\";s:0:\"\";s:29:\"resideo_button_bg_color_field\";s:7:\"#0eaaa6\";s:31:\"resideo_button_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_prop_bg_color_field\";s:7:\"#0eaaa6\";s:34:\"resideo_feat_prop_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_post_bg_color_field\";s:0:\"\";s:34:\"resideo_feat_post_text_color_field\";s:0:\"\";s:33:\"resideo_map_marker_bg_color_field\";s:7:\"#a7d9da\";s:37:\"resideo_map_marker_border_color_field\";s:7:\"#0eaaa6\";s:35:\"resideo_map_marker_text_color_field\";s:7:\"#000000\";s:34:\"resideo_agent_card_cta_color_field\";s:7:\"#0eaaa6\";s:33:\"resideo_post_card_cta_color_field\";s:7:\"#0eaaa6\";s:29:\"resideo_footer_bg_color_field\";s:7:\"#a6d9dc\";s:31:\"resideo_footer_text_color_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:5:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";s:25:\"resideo_gmaps_style_field\";s:2412:\"%5B%7B%22featureType%22%3A%22water%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23e9e9e9%22%7D%2C%7B%22lightness%22%3A17%7D%5D%7D%2C%7B%22featureType%22%3A%22landscape%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23f5f5f5%22%7D%2C%7B%22lightness%22%3A20%7D%5D%7D%2C%7B%22featureType%22%3A%22road.highway%22%2C%22elementType%22%3A%22geometry.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23ffffff%22%7D%2C%7B%22lightness%22%3A17%7D%5D%7D%2C%7B%22featureType%22%3A%22road.highway%22%2C%22elementType%22%3A%22geometry.stroke%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23ffffff%22%7D%2C%7B%22lightness%22%3A29%7D%2C%7B%22weight%22%3A0.2%7D%5D%7D%2C%7B%22featureType%22%3A%22road.arterial%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23ffffff%22%7D%2C%7B%22lightness%22%3A18%7D%5D%7D%2C%7B%22featureType%22%3A%22road.local%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23ffffff%22%7D%2C%7B%22lightness%22%3A16%7D%5D%7D%2C%7B%22featureType%22%3A%22poi%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23f5f5f5%22%7D%2C%7B%22lightness%22%3A21%7D%5D%7D%2C%7B%22featureType%22%3A%22poi.park%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23dedede%22%7D%2C%7B%22lightness%22%3A21%7D%5D%7D%2C%7B%22elementType%22%3A%22labels.text.stroke%22%2C%22stylers%22%3A%5B%7B%22visibility%22%3A%22on%22%7D%2C%7B%22color%22%3A%22%23ffffff%22%7D%2C%7B%22lightness%22%3A16%7D%5D%7D%2C%7B%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22saturation%22%3A36%7D%2C%7B%22color%22%3A%22%23333333%22%7D%2C%7B%22lightness%22%3A40%7D%5D%7D%2C%7B%22elementType%22%3A%22labels.icon%22%2C%22stylers%22%3A%5B%7B%22visibility%22%3A%22off%22%7D%5D%7D%2C%7B%22featureType%22%3A%22transit%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23f2f2f2%22%7D%2C%7B%22lightness%22%3A19%7D%5D%7D%2C%7B%22featureType%22%3A%22administrative%22%2C%22elementType%22%3A%22geometry.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23fefefe%22%7D%2C%7B%22lightness%22%3A20%7D%5D%7D%2C%7B%22featureType%22%3A%22administrative%22%2C%22elementType%22%3A%22geometry.stroke%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23fefefe%22%7D%2C%7B%22lightness%22%3A17%7D%2C%7B%22weight%22%3A1.2%7D%5D%7D%5D\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:8:\"required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}","resideo_property_layout_settings": "a:3:{s:29:\"resideo_property_layout_field\";s:2:\"d6\";s:33:\"resideo_property_layout_top_field\";s:5:\"title\";s:42:\"resideo_property_layout_map_position_field\";s:4:\"left\";}"}';
                break;
            case 'demo-12':
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:9:{s:24:\"resideo_theme_mode_field\";s:4:\"dark\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_colors_settings": "a:17:{s:29:\"resideo_header_bg_color_field\";s:7:\"#3e3e55\";s:31:\"resideo_header_logo_color_field\";s:0:\"\";s:30:\"resideo_header_nav_color_field\";s:0:\"\";s:36:\"resideo_header_user_icon_color_field\";s:0:\"\";s:29:\"resideo_button_bg_color_field\";s:7:\"#ff385c\";s:31:\"resideo_button_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_prop_bg_color_field\";s:7:\"#ff385c\";s:34:\"resideo_feat_prop_text_color_field\";s:7:\"#ffffff\";s:32:\"resideo_feat_post_bg_color_field\";s:7:\"#ff385c\";s:34:\"resideo_feat_post_text_color_field\";s:7:\"#ffffff\";s:33:\"resideo_map_marker_bg_color_field\";s:7:\"#ff385c\";s:37:\"resideo_map_marker_border_color_field\";s:7:\"#000000\";s:35:\"resideo_map_marker_text_color_field\";s:7:\"#ffffff\";s:34:\"resideo_agent_card_cta_color_field\";s:7:\"#ff385c\";s:33:\"resideo_post_card_cta_color_field\";s:7:\"#ff385c\";s:29:\"resideo_footer_bg_color_field\";s:7:\"#3e3e55\";s:31:\"resideo_footer_text_color_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"0\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"1\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"2\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";s:8:\"position\";s:1:\"3\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:5:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";s:25:\"resideo_gmaps_style_field\";s:1646:\"%5B%7B%22featureType%22%3A%22all%22%2C%22elementType%22%3A%22labels.text.fill%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%236c747d%22%7D%5D%7D%2C%7B%22featureType%22%3A%22all%22%2C%22elementType%22%3A%22labels.text.stroke%22%2C%22stylers%22%3A%5B%7B%22visibility%22%3A%22on%22%7D%2C%7B%22color%22%3A%22%2313263c%22%7D%2C%7B%22weight%22%3A2%7D%2C%7B%22gamma%22%3A%221%22%7D%5D%7D%2C%7B%22featureType%22%3A%22all%22%2C%22elementType%22%3A%22labels.icon%22%2C%22stylers%22%3A%5B%7B%22visibility%22%3A%22off%22%7D%5D%7D%2C%7B%22featureType%22%3A%22administrative%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22weight%22%3A0.6%7D%2C%7B%22color%22%3A%22%23223347%22%7D%2C%7B%22gamma%22%3A%220%22%7D%5D%7D%2C%7B%22featureType%22%3A%22landscape%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23223347%22%7D%2C%7B%22gamma%22%3A%221%22%7D%2C%7B%22weight%22%3A%2210%22%7D%5D%7D%2C%7B%22featureType%22%3A%22poi%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%232f3f51%22%7D%5D%7D%2C%7B%22featureType%22%3A%22poi.park%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23283b51%22%7D%5D%7D%2C%7B%22featureType%22%3A%22road%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23182b40%22%7D%2C%7B%22lightness%22%3A%220%22%7D%5D%7D%2C%7B%22featureType%22%3A%22transit%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%23304358%22%7D%5D%7D%2C%7B%22featureType%22%3A%22water%22%2C%22elementType%22%3A%22geometry%22%2C%22stylers%22%3A%5B%7B%22color%22%3A%22%230e2239%22%7D%5D%7D%5D\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:12:\"not_required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}","resideo_property_layout_settings": "a:3:{s:29:\"resideo_property_layout_field\";s:2:\"d2\";s:33:\"resideo_property_layout_top_field\";s:5:\"title\";s:42:\"resideo_property_layout_map_position_field\";s:4:\"left\";}"}';
                break;
            default:
                $theme_settings = '{"resideo_amenities_settings": "a:9:{s:8:\"internet\";a:4:{s:4:\"name\";s:8:\"internet\";s:5:\"label\";s:8:\"Internet\";s:4:\"icon\";s:10:\"fa fa-wifi\";s:8:\"position\";s:1:\"0\";}s:6:\"garage\";a:4:{s:4:\"name\";s:6:\"garage\";s:5:\"label\";s:6:\"Garage\";s:4:\"icon\";s:9:\"fa fa-car\";s:8:\"position\";s:1:\"1\";}s:8:\"elevator\";a:4:{s:4:\"name\";s:8:\"elevator\";s:5:\"label\";s:8:\"Elevator\";s:4:\"icon\";s:10:\"fa fa-sort\";s:8:\"position\";s:1:\"2\";}s:16:\"air_conditioning\";a:4:{s:4:\"name\";s:16:\"air_conditioning\";s:5:\"label\";s:16:\"Air Conditioning\";s:4:\"icon\";s:17:\"fa fa-snowflake-o\";s:8:\"position\";s:1:\"3\";}s:4:\"pool\";a:4:{s:4:\"name\";s:4:\"pool\";s:5:\"label\";s:4:\"Pool\";s:4:\"icon\";s:10:\"fa fa-bath\";s:8:\"position\";s:1:\"4\";}s:10:\"dishwasher\";a:4:{s:4:\"name\";s:10:\"dishwasher\";s:5:\"label\";s:10:\"Dishwasher\";s:4:\"icon\";s:11:\"fa fa-glass\";s:8:\"position\";s:1:\"5\";}s:8:\"disposal\";a:4:{s:4:\"name\";s:8:\"disposal\";s:5:\"label\";s:8:\"Disposal\";s:4:\"icon\";s:13:\"fa fa-recycle\";s:8:\"position\";s:1:\"6\";}s:9:\"fireplace\";a:4:{s:4:\"name\";s:9:\"fireplace\";s:5:\"label\";s:9:\"Fireplace\";s:4:\"icon\";s:10:\"fa fa-fire\";s:8:\"position\";s:1:\"7\";}s:7:\"balcony\";a:4:{s:4:\"name\";s:7:\"balcony\";s:5:\"label\";s:7:\"Balcony\";s:4:\"icon\";s:11:\"fa fa-clone\";s:8:\"position\";s:1:\"8\";}}","resideo_appearance_settings": "a:10:{s:24:\"resideo_theme_mode_field\";s:5:\"light\";s:21:\"resideo_sidebar_field\";s:5:\"right\";s:33:\"resideo_properties_per_page_field\";s:2:\"12\";s:21:\"resideo_details_field\";s:4:\"tabs\";s:21:\"resideo_similar_field\";s:1:\"1\";s:29:\"resideo_agents_per_page_field\";s:2:\"10\";s:28:\"resideo_leads_per_page_field\";s:2:\"10\";s:27:\"resideo_related_posts_field\";s:1:\"1\";s:24:\"resideo_blog_title_field\";s:15:\"Latest Articles\";s:27:\"resideo_blog_subtitle_field\";s:80:\"Read our latest articles on real estate, architecture, interior design, and more\";}","resideo_authentication_settings": "a:2:{s:31:\"resideo_user_registration_field\";s:1:\"1\";s:19:\"resideo_terms_field\";s:0:\"\";}","resideo_fields_settings": "a:6:{s:8:\"built_in\";a:9:{s:4:\"name\";s:8:\"built_in\";s:5:\"label\";s:8:\"Built In\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"0\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_width\";a:9:{s:4:\"name\";s:9:\"lot_width\";s:5:\"label\";s:9:\"Lot Width\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"1\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:9:\"lot_depth\";a:9:{s:4:\"name\";s:9:\"lot_depth\";s:5:\"label\";s:9:\"Lot Depth\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"2\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:7:\"stories\";a:9:{s:4:\"name\";s:7:\"stories\";s:5:\"label\";s:7:\"Stories\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"3\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:10:\"room_count\";a:9:{s:4:\"name\";s:10:\"room_count\";s:5:\"label\";s:10:\"Room Count\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"4\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}s:14:\"parking_spaces\";a:9:{s:4:\"name\";s:14:\"parking_spaces\";s:5:\"label\";s:14:\"Parking Spaces\";s:4:\"type\";s:10:\"text_field\";s:4:\"list\";s:0:\"\";s:9:\"mandatory\";s:2:\"no\";s:8:\"position\";s:1:\"5\";s:6:\"search\";s:2:\"no\";s:6:\"filter\";s:2:\"no\";s:10:\"comparison\";s:5:\"equal\";}}","resideo_general_settings": "a:11:{s:26:\"resideo_auto_country_field\";s:2:\"us\";s:20:\"resideo_locale_field\";s:5:\"en_US\";s:29:\"resideo_currency_symbol_field\";s:1:\"$\";s:33:\"resideo_currency_symbol_pos_field\";s:6:\"before\";s:23:\"resideo_max_price_field\";s:7:\"2500000\";s:24:\"resideo_beds_label_field\";s:2:\"BD\";s:25:\"resideo_baths_label_field\";s:2:\"BA\";s:18:\"resideo_unit_field\";s:2:\"SF\";s:23:\"resideo_max_files_field\";s:2:\"10\";s:27:\"resideo_agents_rating_field\";s:1:\"1\";s:23:\"resideo_copyright_field\";s:16:\"\u00a9 2020 Resideo.\";}","resideo_gmaps_settings": "a:4:{s:23:\"resideo_gmaps_key_field\";s:0:\"\";s:23:\"resideo_gmaps_lat_field\";s:10:\"37.7487769\";s:23:\"resideo_gmaps_lng_field\";s:11:\"-122.424534\";s:24:\"resideo_gmaps_zoom_field\";s:2:\"12\";}","resideo_prop_fields_settings": "a:59:{s:18:\"resideo_p_id_field\";s:8:\"disabled\";s:20:\"resideo_p_id_f_field\";s:2:\"no\";s:24:\"resideo_p_overview_field\";s:8:\"disabled\";s:26:\"resideo_p_overview_r_field\";s:12:\"not_required\";s:23:\"resideo_p_address_field\";s:7:\"enabled\";s:25:\"resideo_p_address_r_field\";s:8:\"required\";s:25:\"resideo_p_address_t_field\";s:4:\"auto\";s:25:\"resideo_p_address_s_field\";s:3:\"yes\";s:25:\"resideo_p_address_f_field\";s:3:\"yes\";s:27:\"resideo_p_coordinates_field\";s:8:\"disabled\";s:29:\"resideo_p_coordinates_r_field\";s:12:\"not_required\";s:24:\"resideo_p_streetno_field\";s:8:\"disabled\";s:26:\"resideo_p_streetno_r_field\";s:12:\"not_required\";s:22:\"resideo_p_street_field\";s:8:\"disabled\";s:24:\"resideo_p_street_r_field\";s:12:\"not_required\";s:28:\"resideo_p_neighborhood_field\";s:7:\"enabled\";s:30:\"resideo_p_neighborhood_r_field\";s:12:\"not_required\";s:30:\"resideo_p_neighborhood_t_field\";s:5:\"input\";s:30:\"resideo_p_neighborhood_s_field\";s:2:\"no\";s:30:\"resideo_p_neighborhood_f_field\";s:3:\"yes\";s:20:\"resideo_p_city_field\";s:7:\"enabled\";s:22:\"resideo_p_city_r_field\";s:12:\"not_required\";s:22:\"resideo_p_city_t_field\";s:5:\"input\";s:22:\"resideo_p_city_s_field\";s:2:\"no\";s:22:\"resideo_p_city_f_field\";s:3:\"yes\";s:21:\"resideo_p_state_field\";s:7:\"enabled\";s:23:\"resideo_p_state_r_field\";s:12:\"not_required\";s:23:\"resideo_p_state_s_field\";s:2:\"no\";s:23:\"resideo_p_state_f_field\";s:3:\"yes\";s:19:\"resideo_p_zip_field\";s:8:\"disabled\";s:21:\"resideo_p_zip_r_field\";s:12:\"not_required\";s:21:\"resideo_p_price_field\";s:7:\"enabled\";s:23:\"resideo_p_price_r_field\";s:12:\"not_required\";s:23:\"resideo_p_price_s_field\";s:2:\"no\";s:23:\"resideo_p_price_f_field\";s:3:\"yes\";s:20:\"resideo_p_size_field\";s:7:\"enabled\";s:22:\"resideo_p_size_r_field\";s:12:\"not_required\";s:22:\"resideo_p_size_f_field\";s:3:\"yes\";s:20:\"resideo_p_beds_field\";s:7:\"enabled\";s:22:\"resideo_p_beds_r_field\";s:12:\"not_required\";s:22:\"resideo_p_beds_s_field\";s:2:\"no\";s:22:\"resideo_p_beds_f_field\";s:3:\"yes\";s:21:\"resideo_p_baths_field\";s:7:\"enabled\";s:23:\"resideo_p_baths_r_field\";s:12:\"not_required\";s:23:\"resideo_p_baths_s_field\";s:2:\"no\";s:23:\"resideo_p_baths_f_field\";s:3:\"yes\";s:20:\"resideo_p_type_field\";s:7:\"enabled\";s:22:\"resideo_p_type_r_field\";s:12:\"not_required\";s:22:\"resideo_p_type_s_field\";s:2:\"no\";s:22:\"resideo_p_type_f_field\";s:3:\"yes\";s:22:\"resideo_p_status_field\";s:7:\"enabled\";s:24:\"resideo_p_status_r_field\";s:12:\"not_required\";s:24:\"resideo_p_status_s_field\";s:3:\"yes\";s:24:\"resideo_p_status_f_field\";s:3:\"yes\";s:26:\"resideo_p_keywords_f_field\";s:2:\"no\";s:27:\"resideo_p_amenities_f_field\";s:3:\"yes\";s:26:\"resideo_p_calculator_field\";s:7:\"enabled\";s:21:\"resideo_p_taxes_field\";s:7:\"enabled\";s:19:\"resideo_p_hoa_field\";s:7:\"enabled\";}"}';
                break;
        }

        $imported_settings = json_decode(wp_specialchars_decode($theme_settings), true);

        foreach ($imported_settings as $key => $data) {
            update_option($key, maybe_unserialize($data));
        }

        echo json_encode(array('setup' => true));
        exit();

        die;
    }
endif;
add_action('wp_ajax_nopriv_resideo_setup_options', 'resideo_setup_options');
add_action('wp_ajax_resideo_setup_options', 'resideo_setup_options');
?>