(function(wp) {
    var registerBlockType = wp.blocks.registerBlockType;

    var TextControl     = wp.components.TextControl;
    var SelectControl   = wp.components.SelectControl;
    var Button          = wp.components.Button;
    var ColorPalette    = wp.components.ColorPalette;

    var el = wp.element.createElement;

    var MediaUpload = wp.blockEditor.MediaUpload;

    var withState = wp.compose.withState;

    var __ = wp.i18n.__;

    function getObjectProperty(obj, prop) {
        var prop = typeof prop !== 'undefined' ? prop : '';
        var obj = typeof obj !== 'undefined' ? obj : '';

        if(!prop || !obj) {
            return '';
        }

        var ret = obj.hasOwnProperty(prop) ? ( String(obj[prop]) !== ''? obj[prop] : '') : '';

        return ret;
    }

    function getAttr(s, n) {
        n = new RegExp(n + '=\"([^\"]+)\"', 'g').exec(s);
        return n ? window.decodeURIComponent(n[1]) : '';
    };

    function ContactControl(props) {
        var attributes    = props.attributes;
        var setAttributes = props.setAttributes;
        var setState      = props.setState;
        var className     = props.className;
        var isSelected    = props.isSelected;

        var data_content = attributes.data_content;
        var data         = window.decodeURIComponent(data_content);
        var data_json    = jQuery.parseJSON(data);

        var title         = getObjectProperty(data_json, 'title');
        var subtitle      = getObjectProperty(data_json, 'subtitle');
        var image         = getObjectProperty(data_json, 'image');
        var image_src     = getObjectProperty(data_json, 'image_src');
        var position      = getObjectProperty(data_json, 'position');
        var margin        = getObjectProperty(data_json, 'margin');
        var text_color    = getObjectProperty(data_json, 'text_color');
        var form_title    = getObjectProperty(data_json, 'form_title');
        var form_subtitle = getObjectProperty(data_json, 'form_subtitle');
        var form_email    = getObjectProperty(data_json, 'form_email');

        var renderTextColorSelector = el('div',
            {
                className: 'components-base-control'
            },
            el('div',
                {
                    className: 'components-base-control__field'
                },
                el('fieldset',
                    {},
                    el('legend',
                        {},
                        el('div',
                            {},
                            el('span',
                                {
                                    className: 'components-base-control__label'
                                },
                                __('Text Color', 'resideo-plugin'),
                            )
                        )
                    ),
                    el(ColorPalette,
                        {
                            value: text_color,
                            colors: [
                                { name: 'Pale pink', color: '#f58fa8' },
                                { name: 'Vivid red', color: '#cd3235' },
                                { name: 'Luminous vivid orange', color: '#fd6a29' },
                                { name: 'Luminous vivid amber', color: '#fcb738' },
                                { name: 'Light green cyan', color: '#80dab7' },
                                { name: 'Vivid green cyan', color: '#2bcd89' },
                                { name: 'Pale cyan blue', color: '#8fd2f9' },
                                { name: 'Vivid cyan blue', color: '#0896df' },
                                { name: 'Vivid purple', color: '#975cdb' },
                                { name: 'Very light gray', color: '#eeeeee' },
                                { name: 'White', color: '#ffffff' },
                                { name: 'Cyan bluish gray', color: '#abb9c2' },
                                { name: 'Very dark gray', color: '#333333' }
                            ],
                            onChange: function(value) {
                                data_json.text_color = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                )
            )
        );

        var contactOptions = [
            el('div',
                {
                    className: 'row'
                },
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(TextControl, 
                        {
                            label: __('Title', 'resideo-plugin'),
                            value: title,
                            placeholder: __('Enter title', 'resideo-plugin'),
                            onChange: function(value) {
                                data_json.title = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                ),
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(TextControl, 
                        {
                            label: __('Subtitle', 'resideo-plugin'),
                            value: subtitle,
                            placeholder: __('Enter subtitle', 'resideo-plugin'),
                            onChange: function(value) {
                                data_json.subtitle = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                )
            ),
            renderTextColorSelector,
            el('div',
                {
                    className: 'row'
                },
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(MediaUpload,
                        {
                            onSelect: function(media) {
                                jQuery('.pxp-block-contact-bg-image-btn')
                                    .css('background-image', 'url(' + media.url + ')')
                                    .text('')
                                    .attr({
                                        'data-src': media.url,
                                        'data-id': media.id
                                    });
                                data_json.image_src = media.url;
                                data_json.image = media.id;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            },
                            type: 'image',
                            render: function(obj) {
                                return el(Button,
                                    {
                                        className: 'pxp-block-contact-bg-image-btn',
                                        'data-src': image_src,
                                        'data-id': image,
                                        style: {
                                            backgroundImage: 'url(' + image_src + ')',
                                        },
                                        onClick: obj.open
                                    },
                                    __('Background Image', 'resideo-plugin')
                                );
                            }
                        }
                    )
                ),
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(SelectControl, 
                        {
                            label: __('Form Position', 'resideo-plugin'),
                            value: position,
                            options: [
                                { label: __('Right', 'resideo-plugin'), value: 'right' },
                                { label: __('Left', 'resideo-plugin'), value: 'left' }
                            ],
                            onChange: function(value) {
                                data_json.position = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    ),
                    el(SelectControl, 
                        {
                            label: __('Margin', 'resideo-plugin'),
                            value: margin,
                            options: [
                                { label: __('No', 'resideo-plugin'), value: 'no' },
                                { label: __('Yes', 'resideo-plugin'), value: 'yes' }
                            ],
                            onChange: function(value) {
                                data_json.margin = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                )
            ),
            el('div',
                {
                    className: 'row'
                },
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(TextControl, 
                        {
                            label: __('Form Title', 'resideo-plugin'),
                            value: form_title,
                            placeholder: __('Enter form title', 'resideo-plugin'),
                            onChange: function(value) {
                                data_json.form_title = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                ),
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(TextControl, 
                        {
                            label: __('Form Subtitle', 'resideo-plugin'),
                            value: form_subtitle,
                            placeholder: __('Enter form subtitle', 'resideo-plugin'),
                            onChange: function(value) {
                                data_json.form_subtitle = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                ),
                el('div',
                    {
                        className: 'col-xs-12 col-sm-6'
                    },
                    el(TextControl, 
                        {
                            label: __('Form Email', 'resideo-plugin'),
                            value: form_email,
                            placeholder: __('Enter form email', 'resideo-plugin'),
                            onChange: function(value) {
                                data_json.form_email = value;
                                setAttributes({ data_content: encodeURIComponent(JSON.stringify(data_json)) });
                            }
                        }
                    )
                )
            ),
        ];

        if (isSelected) {
            return el('div', 
                {
                    className: className
                },
                el('h3', 
                    {
                        className: 'contact-placeholder-header'
                    },
                    title
                ),
                contactOptions
            );
        } else {
            return el('div', 
                {
                    className: className
                },
                el('h3', 
                    {
                        className: 'contact-placeholder-header'
                    },
                    title
                ),
                el('div', 
                    {
                        className: 'contact-placeholder-img'
                    }
                )
            );
        }
    }

    registerBlockType('resideo-plugin/contact', {
        title: __('Contact', 'resideo-plugin'),
        description: __('Resideo contact block.', 'resideo-plugin'),
        icon: {
            src: 'email-alt',
            foreground: '#007cba',
        },
        category: 'widgets',
        keywords: [
            __('contact', 'resideo-plugin'),
            __('email', 'resideo-plugin'),
            __('form', 'resideo-plugin')
        ],
        attributes: {
            data_content: {
                type: 'string',
                default: '%7B%22title%22%3A%22%22%2C%22subtitle%22%3A%22%22%2C%22image%22%3A%22%22%2C%22image_src%22%3A%22%22%2C%22position%22%3A%22right%22%2C%22margin%22%3A%22no%22%2C%22text_color%22%3A%22%23ffffff%22%2C%22form_title%22%3A%22%22%2C%22form_subtitle%22%3A%22%22%2C%22form_email%22%3A%22%22%7D'
            }
        },
        edit: withState({})(ContactControl),
        save: function(props) {
            return null;
        },
    });
})(window.wp);