<?php
/**
 * @package WordPress
 * @subpackage Resideo
 */

require_once 'services.php';
require_once 'recent_properties.php';
require_once 'featured_properties.php';
require_once 'single_property.php';
require_once 'search_properties.php';
require_once 'areas.php';
require_once 'featured_agents.php';
require_once 'membership_plans.php';
require_once 'recent_posts.php';
require_once 'featured_posts.php';
require_once 'testimonials.php';
require_once 'promo.php';
require_once 'slider_promo.php';
require_once 'subscribe.php';
require_once 'gallery_carousel.php';
require_once 'numbers.php';
require_once 'awards.php';
require_once 'contact.php';
require_once 'video.php';

if (!function_exists('resideo_register_shortcodes_buttons')): 
    function resideo_register_shortcodes_buttons($buttons) {
        global $post;

        $buttons = array();

        if (isset($post)) {
            if ($post->post_type == 'page') {
                array_push($buttons, "", "res_services");
                array_push($buttons, "", "res_recent_properties");
                array_push($buttons, "", "res_featured_properties");
                array_push($buttons, "", "res_single_property");
                array_push($buttons, "", "res_search_properties");
                array_push($buttons, "", "res_areas");
                array_push($buttons, "", "res_featured_agents");
                array_push($buttons, "", "res_membership_plans");
                array_push($buttons, "", "res_recent_posts");
                array_push($buttons, "", "res_featured_posts");
                array_push($buttons, "", "res_testimonials");
                array_push($buttons, "", "res_promo");
                array_push($buttons, "", "res_slider_promo");
                array_push($buttons, "", "res_subscribe");
                array_push($buttons, "", "res_gallery_carousel");
                array_push($buttons, "", "res_numbers");
                array_push($buttons, "", "res_awards");
                array_push($buttons, "", "res_contact");
                array_push($buttons, "", "res_video");
            }
        }

        return $buttons;
    }
endif;

if (!function_exists('resideo_add_plugins')): 
    function resideo_add_plugins($plugin_array) {
        $plugin_array['res_services']            = RESIDEO_PLUGIN_PATH . 'shortcodes/js/services.js';
        $plugin_array['res_recent_properties']   = RESIDEO_PLUGIN_PATH . 'shortcodes/js/recent-properties.js';
        $plugin_array['res_featured_properties'] = RESIDEO_PLUGIN_PATH . 'shortcodes/js/featured-properties.js';
        $plugin_array['res_single_property']     = RESIDEO_PLUGIN_PATH . 'shortcodes/js/single-property.js';
        $plugin_array['res_search_properties']   = RESIDEO_PLUGIN_PATH . 'shortcodes/js/search-properties.js';
        $plugin_array['res_areas']               = RESIDEO_PLUGIN_PATH . 'shortcodes/js/areas.js';
        $plugin_array['res_featured_agents']     = RESIDEO_PLUGIN_PATH . 'shortcodes/js/featured-agents.js';
        $plugin_array['res_membership_plans']    = RESIDEO_PLUGIN_PATH . 'shortcodes/js/membership-plans.js';
        $plugin_array['res_recent_posts']        = RESIDEO_PLUGIN_PATH . 'shortcodes/js/recent-posts.js';
        $plugin_array['res_featured_posts']      = RESIDEO_PLUGIN_PATH . 'shortcodes/js/featured-posts.js';
        $plugin_array['res_testimonials']        = RESIDEO_PLUGIN_PATH . 'shortcodes/js/testimonials.js';
        $plugin_array['res_promo']               = RESIDEO_PLUGIN_PATH . 'shortcodes/js/promo.js';
        $plugin_array['res_slider_promo']        = RESIDEO_PLUGIN_PATH . 'shortcodes/js/slider-promo.js';
        $plugin_array['res_subscribe']           = RESIDEO_PLUGIN_PATH . 'shortcodes/js/subscribe.js';
        $plugin_array['res_gallery_carousel']    = RESIDEO_PLUGIN_PATH . 'shortcodes/js/gallery-carousel.js';
        $plugin_array['res_numbers']             = RESIDEO_PLUGIN_PATH . 'shortcodes/js/numbers.js';
        $plugin_array['res_awards']              = RESIDEO_PLUGIN_PATH . 'shortcodes/js/awards.js';
        $plugin_array['res_contact']             = RESIDEO_PLUGIN_PATH . 'shortcodes/js/contact.js';
        $plugin_array['res_video']               = RESIDEO_PLUGIN_PATH . 'shortcodes/js/video.js';

        if(is_rtl()) {
            wp_enqueue_style('res_custom_rtl');
        } else {
            wp_enqueue_style('res_custom');
        }

        wp_enqueue_script('res_modal');
        wp_enqueue_style('font-awesome');
        wp_enqueue_style('simple-line-icons');

        return $plugin_array;
    }
endif;

if (!function_exists('resideo_register_plugin_buttons')): 
    function resideo_register_plugin_buttons() {
        if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
            return;
        }

        add_editor_style(RESIDEO_PLUGIN_PATH . 'shortcodes/css/editor.css');

        if (get_user_option('rich_editing') == 'true') {
            add_filter('mce_external_plugins', 'resideo_add_plugins');
            add_filter('mce_buttons_3', 'resideo_register_shortcodes_buttons');
        }
    }
endif;

if (!function_exists('resideo_admin_enqueue_shortcodes_scripts')): 
    function resideo_admin_enqueue_shortcodes_scripts() {
        wp_enqueue_style('wp-color-picker', false, true);
        wp_enqueue_script('wp-color-picker', false, true);

        if (is_rtl()) {
            wp_register_style('res_custom_rtl', RESIDEO_PLUGIN_PATH . 'shortcodes/css/custom-rtl.css');
        } else {
            wp_register_style('res_custom', RESIDEO_PLUGIN_PATH . 'shortcodes/css/custom.css');
        }

        wp_register_style('font-awesome', RESIDEO_PLUGIN_PATH . 'css/font-awesome.min.css', array(), '4.7.0', 'all');
        wp_register_style('simple-line-icons', RESIDEO_PLUGIN_PATH . 'css/simple-line-icons.css', array(), '2.3.2', 'all');
    }
endif;

if (!function_exists('resideo_register_shortcodes')): 
    function resideo_register_shortcodes() {
        add_shortcode('res_services', 'resideo_services_shortcode');
        add_shortcode('res_recent_properties', 'resideo_recent_properties_shortcode');
        add_shortcode('res_featured_properties', 'resideo_featured_properties_shortcode');
        add_shortcode('res_single_property', 'resideo_single_property_shortcode');
        add_shortcode('res_search_properties', 'resideo_search_properties_shortcode');
        add_shortcode('res_areas', 'resideo_areas_shortcode');
        add_shortcode('res_featured_agents', 'resideo_featured_agents_shortcode');
        add_shortcode('res_membership_plans', 'resideo_membership_plans_shortcode');
        add_shortcode('res_recent_posts', 'resideo_recent_posts_shortcode');
        add_shortcode('res_featured_posts', 'resideo_featured_posts_shortcode');
        add_shortcode('res_testimonials', 'resideo_testimonials_shortcode');
        add_shortcode('res_promo', 'resideo_promo_shortcode');
        add_shortcode('res_slider_promo', 'resideo_slider_promo_shortcode');
        add_shortcode('res_subscribe', 'resideo_subscribe_shortcode');
        add_shortcode('res_gallery_carousel', 'resideo_gallery_carousel_shortcode');
        add_shortcode('res_numbers', 'resideo_numbers_shortcode');
        add_shortcode('res_awards', 'resideo_awards_shortcode');
        add_shortcode('res_contact', 'resideo_contact_shortcode');
        add_shortcode('res_video', 'resideo_video_shortcode');
        add_action('admin_enqueue_scripts', 'resideo_admin_enqueue_shortcodes_scripts');
    }
endif;

foreach (array('post.php', 'post-new.php') as $hook) {
    add_action("admin_head-$hook", 'resideo_admin_head');
    add_action("admin_head-$hook", 'resideo_register_plugin_buttons');
}

if (!function_exists('resideo_get_sh_cities')): 
    function resideo_get_sh_cities() {
        $resideo_cities_settings = get_option('resideo_cities_settings');

        if (is_array($resideo_cities_settings) && count($resideo_cities_settings) > 0) {
            uasort($resideo_cities_settings, "resideo_compare_position");

            $cities = array();

            foreach ($resideo_cities_settings as $key => $value) {
                $city = new stdClass();

                $city->id = $key;
                $city->name = $value['name'];

                array_push($cities, $city);
            }

            return urlencode(json_encode($cities, true));
        } else {
            return '';
        }
    }
endif;

if (!function_exists('resideo_get_sh_neighborhoods')): 
    function resideo_get_sh_neighborhoods() {
        $resideo_neighborhoods_settings = get_option('resideo_neighborhoods_settings');

        if (is_array($resideo_neighborhoods_settings) && count($resideo_neighborhoods_settings) > 0) {
            uasort($resideo_neighborhoods_settings, "resideo_compare_position");

            $neighborhoods = array();

            foreach ($resideo_neighborhoods_settings as $key => $value) {
                $neighborhood = new stdClass();

                $neighborhood->id = $key;
                $neighborhood->name = $value['name'];

                array_push($neighborhoods, $neighborhood);
            }

            return urlencode(json_encode($neighborhoods, true));
        } else {
            return '';
        }
    }
endif;

if (!function_exists('resideo_get_sh_properties')): 
    function resideo_get_sh_properties() {
        $args = array(
            'posts_per_page' => -1,
            'post_type'      => 'property',
            'orderby'        => 'post_title',
            'order'          => 'ASC',
            'post_status'    => 'publish',
        );
        $props = array();

        $posts = get_posts($args);

        foreach ($posts as $post) : setup_postdata($post);
            $prop = new stdClass();

            $prop->id = $post->ID;
            $prop->title = $post->post_title;

            array_push($props, $prop);
        endforeach;

        wp_reset_postdata();
        wp_reset_query();

        if (count($props) > 0) {
            return urlencode(json_encode($props, true));
        } else {
            return '';
        }
    }
endif;

if (!function_exists('resideo_get_sh_property_custom_fields')): 
    function resideo_get_sh_property_custom_fields() {
        $custom_fields_settings = get_option('resideo_fields_settings');

        if (is_array($custom_fields_settings)) {
            uasort($custom_fields_settings, "resideo_compare_position");

            return urlencode(json_encode($custom_fields_settings, true));
        } else {
            return '';
        }
    }
endif;

function resideo_admin_head() {
    $plugin_url = plugins_url('/', __FILE__);

    $fields_settings   = get_option('resideo_prop_fields_settings');
    $city_type         = isset($fields_settings['resideo_p_city_t_field']) ? $fields_settings['resideo_p_city_t_field'] : '';
    $neighborhood_type = isset($fields_settings['resideo_p_neighborhood_t_field']) ? $fields_settings['resideo_p_neighborhood_t_field'] : '';

    $resideo_gmaps_settings = get_option('resideo_gmaps_settings', '');
    $default_lat            = isset($resideo_gmaps_settings['resideo_gmaps_lat_field']) ? $resideo_gmaps_settings['resideo_gmaps_lat_field'] : '';
    $default_lng            = isset($resideo_gmaps_settings['resideo_gmaps_lng_field']) ? $resideo_gmaps_settings['resideo_gmaps_lng_field'] : '';

    $resideo_general_settings = get_option('resideo_general_settings', '');
    $auto_country             = isset($resideo_general_settings['resideo_auto_country_field']) ? $resideo_general_settings['resideo_auto_country_field'] : '';

    $appearance_settings = get_option('resideo_appearance_settings');
    $hide_agents_phone = isset($appearance_settings['resideo_hide_agents_phone_field']) ? $appearance_settings['resideo_hide_agents_phone_field'] : ''; ?>

    <!-- TinyMCE Shortcode Plugin -->
    <script type='text/javascript'>
    var sh_vars = {
        'admin_url'                           : '<?php echo get_admin_url(); ?>',
        'ajaxurl'                             : '<?php echo admin_url('admin-ajax.php'); ?>',
        'plugin_url'                          : '<?php echo RESIDEO_PLUGIN_PATH; ?>',
        'services_title'                      : '<?php esc_html_e('Services', 'resideo-plugin'); ?>',
        'cancel_btn'                          : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'insert_btn'                          : '<?php esc_html_e('Insert', 'resideo-plugin'); ?>',
        'title_label'                         : '<?php esc_html_e('Title', 'resideo-plugin'); ?>',
        'title_placeholder'                   : '<?php esc_html_e('Enter title', 'resideo-plugin'); ?>',
        'subtitle_label'                      : '<?php esc_html_e('Subtitle', 'resideo-plugin'); ?>',
        'subtitle_placeholder'                : '<?php esc_html_e('Enter subtitle', 'resideo-plugin'); ?>',
        'services_list'                       : '<?php esc_html_e('Services List', 'resideo-plugin'); ?>',
        'add_service_btn'                     : '<?php esc_html_e('Add New Service', 'resideo-plugin'); ?>',
        'empty_list'                          : '<?php esc_html_e('The list is empty.', 'resideo-plugin'); ?>',
        'service_title_label'                 : '<?php esc_html_e('Service Title', 'resideo-plugin'); ?>',
        'service_title_placeholder'           : '<?php esc_html_e('Enter service title', 'resideo-plugin'); ?>',
        'service_text_label'                  : '<?php esc_html_e('Service Text', 'resideo-plugin'); ?>',
        'service_text_placeholder'            : '<?php esc_html_e('Enter service text', 'resideo-plugin'); ?>',
        'new_service_header'                  : '<?php esc_html_e('New Service', 'resideo-plugin'); ?>',
        'service_link_label'                  : '<?php esc_html_e('Service Link', 'resideo-plugin'); ?>',
        'service_link_placeholder'            : '<?php esc_html_e('Enter service link', 'resideo-plugin'); ?>',
        'service_cta_label'                   : '<?php esc_html_e('Service CTA Label', 'resideo-plugin'); ?>',
        'service_cta_label_placeholder'       : '<?php esc_html_e('Enter service CTA lablel', 'resideo-plugin'); ?>',
        'ok_service_btn'                      : '<?php esc_html_e('Add', 'resideo-plugin'); ?>',
        'cancel_service_btn'                  : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'service_add_img'                     : '<?php esc_html_e('Add Image', 'resideo-plugin'); ?>',
        'service_add_icon'                    : '<?php esc_html_e('Add Icon', 'resideo-plugin'); ?>',
        'service_image'                       : '<?php esc_html_e('Service Image', 'resideo-plugin'); ?>',
        'service_insert_image'                : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'edit_service_header'                 : '<?php esc_html_e('Edit Service', 'resideo-plugin'); ?>',
        'ok_edit_service_btn'                 : '<?php esc_html_e('OK', 'resideo-plugin'); ?>',
        'service_icon_color'                  : '<?php esc_html_e('Icon Color', 'resideo-plugin'); ?>',
        'recent_properties_title'             : '<?php esc_html_e('Recent Properties', 'resideo-plugin'); ?>',
        'featured_properties_title'           : '<?php esc_html_e('Featured Properties', 'resideo-plugin'); ?>',
        'remove_btn'                          : '<?php esc_html_e('Remove', 'resideo-plugin'); ?>',
        'edit_btn'                            : '<?php esc_html_e('Edit', 'resideo-plugin'); ?>',
        'all_label'                           : '<?php esc_html_e('All', 'resideo-plugin'); ?>',
        'type_label'                          : '<?php esc_html_e('Type', 'resideo-plugin'); ?>',
        'status_label'                        : '<?php esc_html_e('Status', 'resideo-plugin'); ?>',
        'prop_number_label'                   : '<?php esc_html_e('Number of Properties', 'resideo-plugin'); ?>',
        'prop_number_placeholder'             : '<?php esc_html_e('Enter number of properties', 'resideo-plugin'); ?>',
        'cards_design_label'                  : '<?php esc_html_e('Cards Design', 'resideo-plugin'); ?>',
        'cards_display_label'                 : '<?php esc_html_e('Display', 'resideo-plugin'); ?>',
        'columns_type_label'                  : '<?php esc_html_e('Column Type', 'resideo-plugin'); ?>',
        'sh_delete_confirmation'              : '<?php esc_html_e('Are you sure you want to delete the shortcode?', 'resideo-plugin'); ?>',
        'info_title'                          : '<?php esc_html_e('Info', 'resideo-plugin'); ?>',
        'cta_text_label'                      : '<?php esc_html_e('CTA Button Text', 'resideo-plugin'); ?>',
        'cta_text_placeholder'                : '<?php esc_html_e('Enter the CTA button text', 'resideo-plugin'); ?>',
        'cta_link_label'                      : '<?php esc_html_e('CTA Button Link', 'resideo-plugin'); ?>',
        'cta_link_placeholder'                : '<?php esc_html_e('Enter the CTA button link', 'resideo-plugin'); ?>',
        'card_cta_text_label'                 : '<?php esc_html_e('Agent Card CTA text', 'resideo-plugin'); ?>',
        'card_cta_text_placeholder'           : '<?php esc_html_e('Enter the CTA text', 'resideo-plugin'); ?>',
        'img_label'                           : '<?php esc_html_e('Background Image', 'resideo-plugin'); ?>',
        'media_info_image_title'              : '<?php esc_html_e('Info Background Image', 'resideo-plugin'); ?>',
        'media_info_image_btn'                : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'media_services_image_title'          : '<?php esc_html_e('Services Background Image', 'resideo-plugin'); ?>',
        'media_services_image_btn'            : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'color_label'                         : '<?php esc_html_e('Background Color', 'resideo-plugin'); ?>',
        'color_opacity_label'                 : '<?php esc_html_e('Background Color Opacity', 'resideo-plugin'); ?>',
        'width_label'                         : '<?php esc_html_e('Width', 'resideo-plugin'); ?>',
        'wide_label'                          : '<?php esc_html_e('Wide', 'resideo-plugin'); ?>',
        'boxed_label'                         : '<?php esc_html_e('Boxed', 'resideo-plugin'); ?>',
        'height_label'                        : '<?php esc_html_e('Height', 'resideo-plugin'); ?>',
        'height_placeholder'                  : '<?php esc_html_e('Enter the height', 'resideo-plugin'); ?>',
        'search_properties_title'             : '<?php esc_html_e('Search Properties', 'resideo-plugin'); ?>',
        'fields_list_label'                   : '<?php esc_html_e('Fields List', 'resideo-plugin'); ?>',
        'sp_id_label'                         : '<?php esc_html_e('Property ID', 'resideo-plugin'); ?>',
        'sp_address_label'                    : '<?php esc_html_e('Address', 'resideo-plugin'); ?>',
        'sp_city_label'                       : '<?php esc_html_e('City', 'resideo-plugin'); ?>',
        'sp_neighborhood_label'               : '<?php esc_html_e('Neighborhood', 'resideo-plugin'); ?>',
        'sp_state_label'                      : '<?php esc_html_e('County/State', 'resideo-plugin'); ?>',
        'sp_price_label'                      : '<?php esc_html_e('Price', 'resideo-plugin'); ?>',
        'sp_size_label'                       : '<?php esc_html_e('Size', 'resideo-plugin'); ?>',
        'sp_beds_label'                       : '<?php esc_html_e('Beds', 'resideo-plugin'); ?>',
        'sp_baths_label'                      : '<?php esc_html_e('Baths', 'resideo-plugin'); ?>',
        'sp_type_label'                       : '<?php esc_html_e('Type', 'resideo-plugin'); ?>',
        'sp_status_label'                     : '<?php esc_html_e('Status', 'resideo-plugin'); ?>',
        'sp_keywords_label'                   : '<?php esc_html_e('Keywords', 'resideo-plugin'); ?>',
        'sp_amenities_label'                  : '<?php esc_html_e('Amenities', 'resideo-plugin'); ?>',
        'custom_fields_list_label'            : '<?php esc_html_e('Custom Fields List', 'resideo-plugin'); ?>',
        'limit_main_fields_label'             : '<?php esc_html_e('Limit Main Fields', 'resideo-plugin'); ?>',
        'fields_display_label'                : '<?php esc_html_e('Display', 'resideo-plugin'); ?>',
        'fields_main_area_label'              : '<?php esc_html_e('fields in main area', 'resideo-plugin'); ?>',
        'areas_title'                         : '<?php esc_html_e('Areas', 'resideo-plugin'); ?>',
        'areas_list'                          : '<?php esc_html_e('Areas List', 'resideo-plugin'); ?>',
        'add_area_btn'                        : '<?php esc_html_e('Add New Area', 'resideo-plugin'); ?>',
        'new_area_header'                     : '<?php esc_html_e('New Area', 'resideo-plugin'); ?>',
        'area_add_img'                        : '<?php esc_html_e('Add Image', 'resideo-plugin'); ?>',
        'area_neighborhood_label'             : '<?php esc_html_e('Neighborhood', 'resideo-plugin'); ?>',
        'area_neighborhood_placeholder'       : '<?php esc_html_e('Enter neighborhood', 'resideo-plugin'); ?>',
        'area_city_label'                     : '<?php esc_html_e('City', 'resideo-plugin'); ?>',
        'area_city_placeholder'               : '<?php esc_html_e('Enter city', 'resideo-plugin'); ?>',
        'ok_area_btn'                         : '<?php esc_html_e('Add', 'resideo-plugin'); ?>',
        'cancel_area_btn'                     : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'edit_area_header'                    : '<?php esc_html_e('Edit Area', 'resideo-plugin'); ?>',
        'ok_edit_area_btn'                    : '<?php esc_html_e('OK', 'resideo-plugin'); ?>',
        'cancel_edit_area_btn'                : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'area_image'                          : '<?php esc_html_e('Area Image', 'resideo-plugin'); ?>',
        'area_insert_image'                   : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'areas_cities_list'                   : '<?php echo resideo_get_sh_cities(); ?>',
        'areas_neighborhoods_list'            : '<?php echo resideo_get_sh_neighborhoods(); ?>',
        'areas_city_type'                     : '<?php echo esc_html($city_type); ?>',
        'areas_neighborhood_type'             : '<?php echo esc_html($neighborhood_type); ?>',
        'areas_select_neighborhood'           : '<?php esc_html_e('Select a neighborhood', 'resideo-plugin'); ?>',
        'areas_select_city'                   : '<?php esc_html_e('Select a city', 'resideo-plugin'); ?>',
        'properties_title'                    : '<?php esc_html_e('Properties Slider', 'resideo-plugin'); ?>',
        'properties_list'                     : '<?php esc_html_e('Properties List', 'resideo-plugin'); ?>',
        'add_property_btn'                    : '<?php esc_html_e('Add Property', 'resideo-plugin'); ?>',
        'modal_properties'                    : '<?php esc_html_e('Properties', 'resideo-plugin'); ?>',
        'search_properties'                   : '<?php esc_html_e('Search properties', 'resideo-plugin'); ?>',
        'modal_properties_results'            : '<?php esc_html_e('Properties', 'resideo-plugin'); ?>',
        'load_more_properties'                : '<?php esc_html_e('Load 20 more properties', 'resideo-plugin'); ?>',
        'modal_no_properties'                 : '<?php esc_html_e('No properties found.', 'resideo-plugin'); ?>',
        'autoslide_label'                     : '<?php esc_html_e('Autoslide', 'resideo-plugin'); ?>',
        'autoslide_no'                        : '<?php esc_html_e('No', 'resideo-plugin'); ?>',
        'autoslide_yes'                       : '<?php esc_html_e('Yes', 'resideo-plugin'); ?>',
        'interval_label'                      : '<?php esc_html_e('Autoslide Interval', 'resideo-plugin'); ?>',
        'seconds_label'                       : '<?php esc_html_e('seconds', 'resideo-plugin'); ?>',
        'transition_label'                    : '<?php esc_html_e('Transition', 'resideo-plugin'); ?>',
        'margin_label'                        : '<?php esc_html_e('Margin', 'resideo-plugin'); ?>',
        'margin_no'                           : '<?php esc_html_e('No', 'resideo-plugin'); ?>',
        'margin_yes'                          : '<?php esc_html_e('Yes', 'resideo-plugin'); ?>',
        'transition_slide'                    : '<?php esc_html_e('Slide', 'resideo-plugin'); ?>',
        'transition_fade'                     : '<?php esc_html_e('Fade', 'resideo-plugin'); ?>',
        'opacity_label'                       : '<?php esc_html_e('Caption Background Opacity', 'resideo-plugin'); ?>',
        'width_label'                         : '<?php esc_html_e('Width', 'resideo-plugin'); ?>',
        'width_wide'                          : '<?php esc_html_e('Wide', 'resideo-plugin'); ?>',
        'width_boxed'                         : '<?php esc_html_e('Boxed', 'resideo-plugin'); ?>',
        'recent_posts_title'                  : '<?php esc_html_e('Recent Blog Posts', 'resideo-plugin'); ?>',
        'posts_number_label'                  : '<?php esc_html_e('Number of Posts', 'resideo-plugin'); ?>',
        'posts_number_placeholder'            : '<?php esc_html_e('Enter number of posts', 'resideo-plugin'); ?>',
        'featured_posts_title'                : '<?php esc_html_e('Featured Blog Posts', 'resideo-plugin'); ?>',
        'featured_agents_title'               : '<?php esc_html_e('Featured Agents', 'resideo-plugin'); ?>',
        'agents_number_label'                 : '<?php esc_html_e('Number of Agents', 'resideo-plugin'); ?>',
        'agents_number_placeholder'           : '<?php esc_html_e('Enter number of agents', 'resideo-plugin'); ?>',
        'testimonials_title'                  : '<?php esc_html_e('Testimonials', 'resideo-plugin'); ?>',
        'media_testimonials_image_title'      : '<?php esc_html_e('Testimonials Background Image', 'resideo-plugin'); ?>',
        'media_testimonials_image_btn'        : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'membership_plans_title'              : '<?php esc_html_e('Membership Plans', 'resideo-plugin'); ?>',
        'columns_title'                       : '<?php esc_html_e('Columns', 'resideo-plugin'); ?>',
        'contact_title'                       : '<?php esc_html_e('Contact', 'resideo-plugin'); ?>',
        'business_name_label'                 : '<?php esc_html_e('Business Name', 'resideo-plugin'); ?>',
        'business_name_placeholder'           : '<?php esc_html_e('Enter company/business name', 'resideo-plugin'); ?>',
        'phone_label'                         : '<?php esc_html_e('Phone Number', 'resideo-plugin'); ?>',
        'phone_placeholder'                   : '<?php esc_html_e('Enter phone number', 'resideo-plugin'); ?>',
        'address_label'                       : '<?php esc_html_e('Address', 'resideo-plugin'); ?>',
        'address_placeholder'                 : '<?php esc_html_e('Enter address', 'resideo-plugin'); ?>',
        'position_btn'                        : '<?php esc_html_e('Position pin by address', 'resideo-plugin'); ?>',
        'lat_label'                           : '<?php esc_html_e('Latitude', 'resideo-plugin'); ?>',
        'lat_placeholder'                     : '<?php esc_html_e('Enter latitude', 'resideo-plugin'); ?>',
        'lng_label'                           : '<?php esc_html_e('Longitude', 'resideo-plugin'); ?>',
        'lng_placeholder'                     : '<?php esc_html_e('Enter longitude', 'resideo-plugin'); ?>',
        'email_label'                         : '<?php esc_html_e('Email address', 'resideo-plugin'); ?>',
        'email_placeholder'                   : '<?php esc_html_e('Enter email address', 'resideo-plugin'); ?>',
        'form_label'                          : '<?php esc_html_e('Display Contact Form', 'resideo-plugin'); ?>',
        'form_no'                             : '<?php esc_html_e('No', 'resideo-plugin'); ?>',
        'form_yes'                            : '<?php esc_html_e('Yes', 'resideo-plugin'); ?>',
        'default_lat'                         : '<?php echo esc_html($default_lat); ?>',
        'default_lng'                         : '<?php echo esc_html($default_lng); ?>',
        'auto_country'                        : '<?php echo esc_html($auto_country); ?>',
        'geocode_error'                       : '<?php esc_html_e('Geocode was not successful for the following reason', 'resideo-plugin'); ?>',
        'marker_label'                        : '<?php esc_html_e('Marker', 'resideo-plugin'); ?>',
        'marker_title'                        : '<?php esc_html_e('Map Marker', 'resideo-plugin'); ?>',
        'marker_btn'                          : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'map_position_label'                  : '<?php esc_html_e('Map Position', 'resideo-plugin'); ?>',
        'map_position_right'                  : '<?php esc_html_e('Right', 'resideo-plugin'); ?>',
        'map_position_left'                   : '<?php esc_html_e('Left', 'resideo-plugin'); ?>',
        'align_label'                         : '<?php esc_html_e('Align', 'resideo-plugin'); ?>',
        'align_left'                          : '<?php esc_html_e('Left', 'resideo-plugin'); ?>',
        'align_center'                        : '<?php esc_html_e('Center', 'resideo-plugin'); ?>',
        'align_right'                         : '<?php esc_html_e('Right', 'resideo-plugin'); ?>',
        'promo_title'                         : '<?php esc_html_e('Promo', 'resideo-plugin'); ?>',
        'text_label'                          : '<?php esc_html_e('Text', 'resideo-plugin'); ?>',
        'text_placeholder'                    : '<?php esc_html_e('Enter text', 'resideo-plugin'); ?>',
        'caption_position_label'              : '<?php esc_html_e('Caption Position', 'resideo-plugin'); ?>',
        'image_position_label'                : '<?php esc_html_e('Image Position', 'resideo-plugin'); ?>',
        'right_label'                         : '<?php esc_html_e('Right', 'resideo-plugin'); ?>',
        'left_label'                          : '<?php esc_html_e('Left', 'resideo-plugin'); ?>',
        'media_promo_image_title'             : '<?php esc_html_e('Image', 'resideo-plugin'); ?>',
        'media_promo_image_btn'               : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'promo_img_label'                     : '<?php esc_html_e('Image', 'resideo-plugin'); ?>',
        'text_align_label'                    : '<?php esc_html_e('Text Align', 'resideo-plugin'); ?>',
        'layout_label'                        : '<?php esc_html_e('Layout', 'resideo-plugin'); ?>',
        'top_left_label'                      : '<?php esc_html_e('Top Left', 'resideo-plugin'); ?>',
        'top_right_label'                     : '<?php esc_html_e('Top Right', 'resideo-plugin'); ?>',
        'center_left_label'                   : '<?php esc_html_e('Center Left', 'resideo-plugin'); ?>',
        'center_label'                        : '<?php esc_html_e('Center', 'resideo-plugin'); ?>',
        'center_right_label'                  : '<?php esc_html_e('Center Right', 'resideo-plugin'); ?>',
        'bottom_left_label'                   : '<?php esc_html_e('Bottom Left', 'resideo-plugin'); ?>',
        'bottom_right_label'                  : '<?php esc_html_e('Bottom Right', 'resideo-plugin'); ?>',
        'subscribe_title'                     : '<?php esc_html_e('Subscribe', 'resideo-plugin'); ?>',
        'media_subscribe_image_title'         : '<?php esc_html_e('Subscribe Background Image', 'resideo-plugin'); ?>',
        'media_subscribe_image_btn'           : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'service_cta_color'                   : '<?php esc_html_e('Service CTA Color', 'resideo-plugin'); ?>',
        'cta_button_color'                    : '<?php esc_html_e('CTA Button Color', 'resideo-plugin'); ?>',
        'area_cta_color'                      : '<?php esc_html_e('Area CTA Color', 'resideo-plugin'); ?>',
        'agent_card_cta_color'                : '<?php esc_html_e('Agent Card CTA Color', 'resideo-plugin'); ?>',
        'plans_title_color'                   : '<?php esc_html_e('Plans Title Color', 'resideo-plugin'); ?>',
        'plans_price_color'                   : '<?php esc_html_e('Plans Price Color', 'resideo-plugin'); ?>',
        'plans_cta_color'                     : '<?php esc_html_e('Plans CTA Color', 'resideo-plugin'); ?>',
        'featured_plan_title_color'           : '<?php esc_html_e('Featured Plan Title Color', 'resideo-plugin'); ?>',
        'featured_plan_price_color'           : '<?php esc_html_e('Featured Plan Price Color', 'resideo-plugin'); ?>',
        'featured_plan_cta_color'             : '<?php esc_html_e('Featured Plan CTA Color', 'resideo-plugin'); ?>',
        'featured_plan_label_color'           : '<?php esc_html_e('Featured Plan Label Color', 'resideo-plugin'); ?>',
        'blog_post_card_cta_color'            : '<?php esc_html_e('Post Card CTA Color', 'resideo-plugin'); ?>',
        'gallery_carousel_title'              : '<?php esc_html_e('Gallery Carousel', 'resideo-plugin'); ?>',
        'gallery_carousel_photos'             : '<?php esc_html_e('Gallery Carousel Photos', 'resideo-plugin'); ?>',
        'add_gallery_carousel_photo_btn'      : '<?php esc_html_e('Add New Photo', 'resideo-plugin'); ?>',
        'new_gallery_carousel_photo_header'   : '<?php esc_html_e('New Photo', 'resideo-plugin'); ?>',
        'gallery_carousel_photo_add_img'      : '<?php esc_html_e('Add Photo', 'resideo-plugin'); ?>',
        'ok_gallery_carousel_photo_btn'       : '<?php esc_html_e('Add', 'resideo-plugin'); ?>',
        'cancel_gallery_carousel_photo_btn'   : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'edit_gallery_carousel_photo_header'  : '<?php esc_html_e('Edit Photo', 'resideo-plugin'); ?>',
        'ok_edit_gallery_carousel_photo_btn'  : '<?php esc_html_e('OK', 'resideo-plugin'); ?>',
        'gallery_carousel_photo'              : '<?php esc_html_e('Photo', 'resideo-plugin'); ?>',
        'gallery_carousel_insert_photo'       : '<?php esc_html_e('Insert Photo', 'resideo-plugin'); ?>',
        'numbers_title'                       : '<?php esc_html_e('Numbers', 'resideo-plugin'); ?>',
        'numbers_list'                        : '<?php esc_html_e('Numbers List', 'resideo-plugin'); ?>',
        'add_number_btn'                      : '<?php esc_html_e('Add New Number', 'resideo-plugin'); ?>',
        'new_number_header'                   : '<?php esc_html_e('New Number', 'resideo-plugin'); ?>',
        'number_sum_label'                    : '<?php esc_html_e('Number', 'resideo-plugin'); ?>',
        'number_sum_placeholder'              : '<?php esc_html_e('Enter number', 'resideo-plugin'); ?>',
        'number_sign_label'                   : '<?php esc_html_e('Number sign', 'resideo-plugin'); ?>',
        'number_sign_placeholder'             : '<?php esc_html_e('Enter number sign', 'resideo-plugin'); ?>',
        'number_delay_label'                  : '<?php esc_html_e('Number animation delay', 'resideo-plugin'); ?>',
        'number_delay_placeholder'            : '<?php esc_html_e('Enter number delay', 'resideo-plugin'); ?>',
        'number_increment_label'              : '<?php esc_html_e('Number increment', 'resideo-plugin'); ?>',
        'number_increment_placeholder'        : '<?php esc_html_e('Enter number increment', 'resideo-plugin'); ?>',
        'number_title_label'                  : '<?php esc_html_e('Number Title', 'resideo-plugin'); ?>',
        'number_title_placeholder'            : '<?php esc_html_e('Enter number title', 'resideo-plugin'); ?>',
        'number_text_label'                   : '<?php esc_html_e('Number Text', 'resideo-plugin'); ?>',
        'number_text_placeholder'             : '<?php esc_html_e('Enter number text', 'resideo-plugin'); ?>',
        'ok_number_btn'                       : '<?php esc_html_e('Add', 'resideo-plugin'); ?>',
        'cancel_number_btn'                   : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'media_numbers_image_title'           : '<?php esc_html_e('Numbers Background Image', 'resideo-plugin'); ?>',
        'media_numbers_image_btn'             : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'edit_number_header'                  : '<?php esc_html_e('Edit Number', 'resideo-plugin'); ?>',
        'ok_edit_number_btn'                  : '<?php esc_html_e('OK', 'resideo-plugin'); ?>',
        'cancel_number_btn'                   : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'awards_title'                        : '<?php esc_html_e('Awards', 'resideo-plugin'); ?>',
        'awards_list'                         : '<?php esc_html_e('Awards List', 'resideo-plugin'); ?>',
        'add_award_btn'                       : '<?php esc_html_e('Add New Award', 'resideo-plugin'); ?>',
        'new_award_header'                    : '<?php esc_html_e('New Award', 'resideo-plugin'); ?>',
        'award_add_img'                       : '<?php esc_html_e('Add Image', 'resideo-plugin'); ?>',
        'award_title_label'                   : '<?php esc_html_e('Award Title', 'resideo-plugin'); ?>',
        'award_title_placeholder'             : '<?php esc_html_e('Enter award title', 'resideo-plugin'); ?>',
        'ok_award_btn'                        : '<?php esc_html_e('Add', 'resideo-plugin'); ?>',
        'cancel_award_btn'                    : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'edit_award_header'                   : '<?php esc_html_e('Edit Award', 'resideo-plugin'); ?>',
        'ok_edit_award_btn'                   : '<?php esc_html_e('OK', 'resideo-plugin'); ?>',
        'cancel_award_btn'                    : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'award_image'                         : '<?php esc_html_e('Award Image', 'resideo-plugin'); ?>',
        'award_insert_image'                  : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'single_property_title'               : '<?php esc_html_e('Single Property', 'resideo-plugin'); ?>',
        'single_property_name_label'          : '<?php esc_html_e('Property Name', 'resideo-plugin'); ?>',
        'single_property_name_placeholder'    : '<?php esc_html_e('Search for a property...', 'resideo-plugin'); ?>',
        'single_property_image_position_label': '<?php esc_html_e('Image Position', 'resideo-plugin'); ?>',
        'hide_agents_phone'                   : '<?php echo esc_html($hide_agents_phone); ?>',
        'search_properties_title'             : '<?php esc_html_e('Search Properties', 'resideo-plugin'); ?>',
        'property_custom_fields'              : '<?php echo resideo_get_sh_property_custom_fields(); ?>',
        'slider_promo_title'                  : '<?php esc_html_e('Promo Slider', 'resideo-plugin'); ?>',
        'cta_buttons_color'                   : '<?php esc_html_e('CTA Buttons Color', 'resideo-plugin'); ?>',
        'promo_slides'                        : '<?php esc_html_e('Slides', 'resideo-plugin'); ?>',
        'add_promo_slide_btn'                 : '<?php esc_html_e('Add New Slide', 'resideo-plugin'); ?>',
        'new_promo_slide_header'              : '<?php esc_html_e('New Slide', 'resideo-plugin'); ?>',
        'promo_slide_add_img'                 : '<?php esc_html_e('Add Image', 'resideo-plugin'); ?>',
        'promo_slide_title_label'             : '<?php esc_html_e('Slide Title', 'resideo-plugin'); ?>',
        'promo_slide_title_placeholder'       : '<?php esc_html_e('Enter slide title', 'resideo-plugin'); ?>',
        'promo_slide_text_label'              : '<?php esc_html_e('Slide Text', 'resideo-plugin'); ?>',
        'promo_slide_text_placeholder'        : '<?php esc_html_e('Enter slide text', 'resideo-plugin'); ?>',
        'ok_promo_slide_btn'                  : '<?php esc_html_e('Add', 'resideo-plugin'); ?>',
        'cancel_promo_slide_btn'              : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'edit_slide_header'                   : '<?php esc_html_e('Edit Slide', 'resideo-plugin'); ?>',
        'ok_edit_promo_slide_btn'             : '<?php esc_html_e('OK', 'resideo-plugin'); ?>',
        'cancel_edit_promo_slide_btn'         : '<?php esc_html_e('Cancel', 'resideo-plugin'); ?>',
        'slide_image'                         : '<?php esc_html_e('Slide Image', 'resideo-plugin'); ?>',
        'slide_insert_image'                  : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'text_color_label'                    : '<?php esc_html_e('Text Color', 'resideo-plugin'); ?>',
        'cta_color_label'                     : '<?php esc_html_e('CTA Color', 'resideo-plugin'); ?>',
        'form_button_color'                   : '<?php esc_html_e('Form Button Color', 'resideo-plugin'); ?>',
        'form_position_label'                 : '<?php esc_html_e('Form Position', 'resideo-plugin'); ?>',
        'contact_img_label'                   : '<?php esc_html_e('Image', 'resideo-plugin'); ?>',
        'media_contact_image_title'           : '<?php esc_html_e('Image', 'resideo-plugin'); ?>',
        'media_contact_image_btn'             : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'form_title_label'                    : '<?php esc_html_e('Form Title', 'resideo-plugin'); ?>',
        'form_subtitle_label'                 : '<?php esc_html_e('Form Subtitle', 'resideo-plugin'); ?>',
        'form_email_label'                    : '<?php esc_html_e('Form Email', 'resideo-plugin'); ?>',
        'form_title_placeholder'              : '<?php esc_html_e('Enter form title', 'resideo-plugin'); ?>',
        'form_subtitle_placeholder'           : '<?php esc_html_e('Enter form subtitle', 'resideo-plugin'); ?>',
        'form_email_placeholder'              : '<?php esc_html_e('Enter form email', 'resideo-plugin'); ?>',
        'video_title'                         : '<?php esc_html_e('Video', 'resideo-plugin'); ?>',
        'media_video_image_title'             : '<?php esc_html_e('Video Background Image', 'resideo-plugin'); ?>',
        'media_video_image_btn'               : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'yt_video_id_label'                   : '<?php esc_html_e('Youtube video ID', 'resideo-plugin'); ?>',
        'caption_icon_label'                  : '<?php esc_html_e('Caption Icon', 'resideo-plugin'); ?>',
        'promo_caption_add_img'               : '<?php esc_html_e('Add Image', 'resideo-plugin'); ?>',
        'promo_caption_add_icon'              : '<?php esc_html_e('Add Icon', 'resideo-plugin'); ?>',
        'promo_caption_image'                 : '<?php esc_html_e('Caption Icon', 'resideo-plugin'); ?>',
        'promo_caption_insert_image'          : '<?php esc_html_e('Insert Image', 'resideo-plugin'); ?>',
        'promo_caption_icon_color'            : '<?php esc_html_e('Caption Icon Color', 'resideo-plugin'); ?>',
        'caption_title_label'                 : '<?php esc_html_e('Caption Title', 'resideo-plugin'); ?>',
        'caption_title_placeholder'           : '<?php esc_html_e('Enter caption title', 'resideo-plugin'); ?>',
        'caption_text_label'                  : '<?php esc_html_e('Caption Text', 'resideo-plugin'); ?>',
        'caption_text_placeholder'            : '<?php esc_html_e('Enter caption text', 'resideo-plugin'); ?>',
        'align_label'                         : '<?php esc_html_e('Align', 'resideo-plugin'); ?>',
        'display_label'                       : '<?php esc_html_e('Display', 'resideo-plugin'); ?>',
        'display_columns'                     : '<?php esc_html_e('Columns', 'resideo-plugin'); ?>',
        'display_grid'                        : '<?php esc_html_e('Grid', 'resideo-plugin'); ?>',
    };
    </script>
    <!-- TinyMCE Shortcode Plugin -->
<?php }

add_action('init', 'resideo_register_shortcodes');

if (!function_exists('resideo_get_types_statuses')): 
    function resideo_get_types_statuses() {
        $type_taxonomies = array( 
            'property_type'
        );
        $type_args = array(
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false
        ); 
        $type_terms = get_terms($type_taxonomies, $type_args);

        $status_taxonomies = array( 
            'property_status'
        );
        $status_args = array(
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false
        ); 
        $status_terms = get_terms($status_taxonomies, $status_args);

        echo json_encode(array('getts' => true, 'types' => $type_terms, 'statuses' => $status_terms));
        exit();

        die();
    }
endif;
add_action('wp_ajax_nopriv_resideo_get_types_statuses', 'resideo_get_types_statuses');
add_action('wp_ajax_resideo_get_types_statuses', 'resideo_get_types_statuses');
?>